/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.util.Map;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.ui.util.InitiatorExt;
import org.zkoss.zkplus.databind.AnnotateDataBinder;

public class AnnotateDataBinderInit
implements Initiator,
InitiatorExt {
    private static final String COMPATIBLE = "org.zkoss.zkplus.databind.AnnotateDataBinderInit.compatible";
    private Component _comp;
    private String _compPath;
    private String _defaultConfig;
    private String _name;
    private boolean _loadOnSave;
    protected AnnotateDataBinder _binder;

    public boolean doCatch(Throwable ex) {
        return false;
    }

    public void doFinally() {
    }

    public void doInit(Page page, Map args) {
        Object loadOnSave;
        boolean hasArg0 = args.containsKey("root");
        Object arg0 = null;
        if (hasArg0) {
            arg0 = args.get("root");
        } else {
            hasArg0 = args.containsKey("arg0");
            if (hasArg0) {
                arg0 = args.get("arg0");
            }
        }
        if (hasArg0) {
            if (arg0 instanceof String) {
                this._compPath = arg0;
            } else if (arg0 instanceof Component) {
                this._comp = arg0;
            } else if (!(arg0 instanceof Page)) {
                throw new UiException("arg0/root has to be String, Component, or Page: " + arg0);
            }
        }
        this._defaultConfig = (String)args.get("loadDefault");
        if (this._defaultConfig == null) {
            this._defaultConfig = (String)args.get("arg1");
        }
        this._name = (String)args.get("name");
        if (this._name == null) {
            this._name = "binder";
        }
        if ((loadOnSave = args.get("loadOnSave")) == null) {
            this._loadOnSave = true;
        } else if (loadOnSave instanceof String) {
            this._loadOnSave = !"false".equals(loadOnSave);
        } else if (loadOnSave instanceof Boolean) {
            this._loadOnSave = (Boolean)loadOnSave;
        }
    }

    private void saveBinder(Component comp) {
        String val = Library.getProperty((String)COMPATIBLE);
        if ("true".equals(val)) {
            comp.setAttribute(this._name, (Object)this._binder, 1);
        } else {
            comp.setAttribute(this._name, (Object)this._binder);
        }
    }

    public void doAfterCompose(Page page, Component[] comps) throws Exception {
        boolean b;
        boolean bl = b = this._defaultConfig != null ? Boolean.valueOf(this._defaultConfig) : true;
        if (this._comp instanceof Component) {
            this._binder = new AnnotateDataBinder(this._comp, b);
            this.saveBinder(this._comp);
        } else if (this._compPath == null || "page".equals(this._compPath)) {
            this._binder = new AnnotateDataBinder(page, b);
            if (page.getAttribute(this._name) != null) {
                throw new UiException("Page is already covered by another Data Binder. Cannot be covered by this Data Binder again. Page:" + page.getId());
            }
            page.setAttribute(this._name, (Object)this._binder);
        } else if (this._compPath.startsWith("/")) {
            Component comp = Path.getComponent((String)this._compPath);
            if (comp == null) {
                throw new UiException("Cannot find the specified component. Absolute Path:" + this._compPath);
            }
            this._binder = new AnnotateDataBinder(comp, b);
            this.saveBinder(comp);
        } else if (this._compPath.startsWith("./") || this._compPath.startsWith("../")) {
            for (int j = 0; j < comps.length; ++j) {
                Component vroot = comps[j];
                Component comp = Path.getComponent((IdSpace)vroot.getSpaceOwner(), (String)this._compPath);
                if (comp == null) continue;
                this._binder = new AnnotateDataBinder(comp, b);
                this.saveBinder(comp);
                break;
            }
            if (this._binder == null) {
                throw new UiException("Cannot find the specified component. Relative Path:" + this._compPath);
            }
        } else {
            Component comp = page.getFellow(this._compPath);
            this._binder = new AnnotateDataBinder(comp, b);
            this.saveBinder(comp);
        }
        this._binder.setLoadOnSave(this._loadOnSave);
        this._binder.loadAll();
    }
}

