/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.sys.ContentRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Applet
extends HtmlBasedComponent
implements DynamicPropertied {
    private String _code;
    private String _codebase;
    private String _archive;
    private String _align;
    private String _hspace;
    private String _vspace;
    private final Map<String, String> _params = new LinkedHashMap<String, String>();
    private boolean _mayscript;

    public String getCode() {
        return this._code;
    }

    public void setCode(String code) {
        if (!Objects.equals((Object)this._code, (Object)code)) {
            this._code = code;
            this.invalidate();
        }
    }

    public String getCodebase() {
        return this._codebase;
    }

    public void setCodebase(String codebase) {
        if (!Objects.equals((Object)this._codebase, (Object)codebase)) {
            this._codebase = codebase;
            this.invalidate();
        }
    }

    public boolean isMayscript() {
        return this._mayscript;
    }

    public void setMayscript(boolean mayscript) {
        if (this._mayscript != mayscript) {
            this._mayscript = mayscript;
            this.invalidate();
        }
    }

    public String getArchive() {
        return this._archive;
    }

    public void setArchive(String archive) {
        if (!Objects.equals((Object)this._archive, (Object)archive)) {
            this._archive = archive;
            this.invalidate();
        }
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.invalidate();
        }
    }

    public String getHspace() {
        return this._hspace;
    }

    public void setHspace(String hspace) {
        if (!Objects.equals((Object)this._hspace, (Object)hspace)) {
            this._hspace = hspace;
            this.invalidate();
        }
    }

    public String getVspace() {
        return this._vspace;
    }

    public void setVspace(String vspace) {
        if (!Objects.equals((Object)this._vspace, (Object)vspace)) {
            this._vspace = vspace;
            this.invalidate();
        }
    }

    public void setParams(Map<String, String> params) {
        this._params.clear();
        if (params != null) {
            this._params.putAll(params);
        }
        this.invalidate();
    }

    public Map<String, String> getParams() {
        return this._params;
    }

    public String setParam(String name, String value) {
        return value != null ? this._params.put(name, value) : this._params.remove(name);
    }

    public Object getDynamicProperty(String name) {
        return this._params.get(name);
    }

    public boolean hasDynamicProperty(String name) {
        return this._params.containsKey(name);
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        this.setParam(name, Objects.toString((Object)value));
    }

    public void invoke(String function) {
        this.response((AuResponse)new AuInvoke((Component)this, "invoke", (Object)function));
    }

    public void invoke(String function, String argument) {
        this.response((AuResponse)new AuInvoke((Component)this, "invoke", (Object)function, (Object)argument));
    }

    public void invoke(String function, String[] arguments) {
        int len = arguments != null ? arguments.length : 0;
        String[] args = new String[len + 1];
        args[0] = function;
        for (int j = 0; j < len; ++j) {
            args[j + 1] = arguments[j];
        }
        this.response((AuResponse)new AuInvoke((Component)this, "invoke", args));
    }

    public void setField(String field, String value) {
        this.response((AuResponse)new AuInvoke((Component)this, "setField", (Object)field, (Object)value));
    }

    protected boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "code", this.getCode());
        this.render(renderer, "codebase", this.encode(this.getCodebase(), true));
        this.render(renderer, "archive", this.encode(this.getArchive(), false));
        this.render(renderer, "align", this.getAlign());
        this.render(renderer, "hspace", this.getHspace());
        this.render(renderer, "vspace", this.getVspace());
        if (this.isMayscript()) {
            renderer.render("mayscript", true);
        }
        this.render(renderer, "params", this._params);
    }

    private String encode(String uri, boolean appendable) {
        int j;
        Desktop dt = this.getDesktop();
        if (uri != null && dt != null && (j = (uri = dt.getExecution().encodeURL(uri)).lastIndexOf(";jsession")) >= 0) {
            uri = uri.substring(0, j);
        }
        return uri;
    }
}

