/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.Flash;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.XYModel;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flashchart
extends Flash {
    private static final long serialVersionUID = 20091126115842L;
    private String _type = "pie";
    private String _chartStyle;
    private ChartModel _model;
    private ChartDataListener _dataListener;
    private LinkedList<JSONObject> _seriesList;
    private String _yAxis = "Series 1";
    private String _xAxis = "Series 2";

    public Flashchart() {
        this.setWidth("400px");
        this.setHeight("200px");
    }

    private void refresh() {
        this.smartUpdate("refresh", this.getJSONResponse(this.transferToJSONObject(this.getModel())));
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "type", this._type.split(":")[0]);
        if (this._chartStyle != null) {
            this.render(renderer, "chartStyle", this._chartStyle);
        }
        this.render(renderer, "jsonModel", this.getJSONResponse(this.transferToJSONObject(this.getModel())));
        if (this._type.startsWith("stackbar") || this._type.startsWith("stackcolumn")) {
            this.render(renderer, "jsonSeries", this.getJSONResponse(this._seriesList));
        }
    }

    public void setType(String type) {
        if (type == null) {
            type = "";
        }
        if (!Objects.equals((Object)this._type, (Object)type)) {
            this._type = type;
            this.invalidate();
        }
    }

    public String getType() {
        return this._type;
    }

    public void setModel(ChartModel model) {
        if (this._model != model) {
            if (this._model != null) {
                this._model.removeChartDataListener(this._dataListener);
            }
            this._model = model;
            if (this._dataListener == null) {
                this._dataListener = new MyChartDataListener();
                this._model.addChartDataListener(this._dataListener);
            }
            this.invalidate();
        }
    }

    public ChartModel getModel() {
        return this._model;
    }

    public void setXaxis(String xAxis) {
        if (xAxis != null) {
            this._xAxis = xAxis;
            this.invalidate();
        }
    }

    public String getXaxis() {
        return this._xAxis;
    }

    public void setYaxis(String yAxis) {
        if (yAxis != null) {
            this._yAxis = yAxis;
            this.invalidate();
        }
    }

    public String getYaxis() {
        return this._yAxis;
    }

    public void setChartStyle(String chartStyle) {
        if (!Objects.equals((Object)this._chartStyle, (Object)chartStyle)) {
            this._chartStyle = chartStyle;
            this.invalidate();
        }
    }

    public String getChartStyle() {
        return this._chartStyle;
    }

    private List<JSONObject> transferToJSONObject(ChartModel model) {
        LinkedList<JSONObject> list = new LinkedList<JSONObject>();
        if (model != null && this._type != null) {
            if ("pie".equals(this._type)) {
                PieModel tempModel = (PieModel)model;
                int nCategories = tempModel.getCategories().size();
                for (int i = 0; i < nCategories; ++i) {
                    Comparable<?> category = tempModel.getCategory(i);
                    JSONObject json = new JSONObject();
                    json.put((Object)"categoryField", category);
                    json.put((Object)"dataField", (Object)tempModel.getValue(category));
                    list.add(json);
                }
            } else if ("bar".equals(this._type) || "line".equals(this._type) || "column".equals(this._type)) {
                CategoryModel tempModel = (CategoryModel)model;
                int nSeries = tempModel.getSeries().size();
                for (int j = 0; j < nSeries; ++j) {
                    Comparable<?> series = tempModel.getSeries(j);
                    int nCategories = tempModel.getCategories().size();
                    for (int i = 0; i < nCategories; ++i) {
                        Comparable<?> category = tempModel.getCategory(i);
                        JSONObject json = new JSONObject();
                        if ("line".equals(this._type) || "column".equals(this._type)) {
                            json.put((Object)"horizontalField", category);
                            json.put((Object)"verticalField", (Object)tempModel.getValue(series, category));
                        } else {
                            json.put((Object)"horizontalField", (Object)tempModel.getValue(series, category));
                            json.put((Object)"verticalField", category);
                        }
                        list.add(json);
                    }
                }
            } else if (this._type.startsWith("stackbar")) {
                int i;
                this._seriesList = new LinkedList();
                CategoryModel tempModel = (CategoryModel)model;
                int nSeries = tempModel.getSeries().size();
                for (i = 0; i < nSeries; ++i) {
                    Comparable<?> series = tempModel.getSeries(i);
                    JSONObject json = new JSONObject();
                    json.put((Object)"xField", series);
                    json.put((Object)"displayName", series);
                    this._seriesList.add(json);
                }
                int nCategories = tempModel.getCategories().size();
                for (i = 0; i < nCategories; ++i) {
                    Comparable<?> category = tempModel.getCategory(i);
                    JSONObject jData = new JSONObject();
                    jData.put((Object)"verticalField", category);
                    for (int j = 0; j < this._seriesList.size(); ++j) {
                        Comparable<?> series = tempModel.getSeries(j);
                        JSONObject temp = this._seriesList.get(j);
                        jData.put(temp.get((Object)"xField"), (Object)tempModel.getValue(series, category));
                    }
                    list.add(jData);
                }
            } else if (this._type.startsWith("stackcolumn")) {
                this._seriesList = new LinkedList();
                XYModel tempModel = (XYModel)model;
                int nSeries = tempModel.getSeries().size();
                for (int i = 0; i < nSeries; ++i) {
                    Comparable<?> series = tempModel.getSeries(i);
                    JSONObject jData = new JSONObject();
                    jData.put((Object)"horizontalField", series);
                    jData.put((Object)this._xAxis, (Object)tempModel.getX(series, 0));
                    jData.put((Object)this._yAxis, (Object)tempModel.getY(series, 0));
                    list.add(jData);
                }
                JSONObject[] json = new JSONObject[]{new JSONObject(), new JSONObject()};
                String tempType = this.getType();
                String tempType_yAxis = "";
                String tempType_xAxis = "";
                if (tempType != null) {
                    tempType = this.getType().indexOf(":") > -1 ? this._type.split(":")[1] : this.getType();
                    tempType_yAxis = tempType.indexOf(",") > -1 ? tempType.split(",")[0] : "";
                    tempType_xAxis = tempType.indexOf(",") > -1 ? tempType.split(",")[1] : "";
                }
                json[0].put((Object)"type", (Object)tempType_yAxis);
                json[0].put((Object)"displayName", (Object)this._yAxis);
                json[0].put((Object)"yField", (Object)this._yAxis);
                this._seriesList.add(json[0]);
                json[1].put((Object)"type", (Object)tempType_xAxis);
                json[1].put((Object)"displayName", (Object)this._xAxis);
                json[1].put((Object)"yField", (Object)this._xAxis);
                this._seriesList.add(json[1]);
            }
        }
        return list;
    }

    private String getJSONResponse(List list) {
        if (list == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer().append('[');
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String s = String.valueOf(it.next());
            sb.append(s).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString().replaceAll("\\\\", "");
    }

    private class MyChartDataListener
    implements ChartDataListener,
    Serializable {
        private static final long serialVersionUID = 20091125153002L;

        private MyChartDataListener() {
        }

        public void onChange(ChartDataEvent event) {
            Flashchart.this.refresh();
        }
    }
}

