/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ext.Sortable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListModelArray<E>
extends AbstractListModel<E>
implements Sortable<E>,
Serializable {
    private static final long serialVersionUID = 20070226L;
    protected final Object[] _array;

    public ListModelArray(E[] array, boolean live) {
        this._array = live ? array : ArraysX.clone((Object[])array);
    }

    public ListModelArray(E[] src) {
        this._array = ArraysX.clone((Object[])src);
    }

    public ListModelArray(int size) {
        this._array = new Object[size];
    }

    public ListModelArray(List<? extends E> list) {
        this._array = list.toArray(new Object[list.size()]);
    }

    public E get(int index) {
        return this.getElementAt(index);
    }

    public void set(int index, E value) {
        this._array[index] = value;
        this.fireEvent(0, index, index);
    }

    public Object[] getInnerArray() {
        return this._array;
    }

    public int indexOf(Object elm) {
        for (int j = 0; j < this._array.length; ++j) {
            if (!Objects.equals((Object)elm, (Object)this._array[j])) continue;
            return j;
        }
        return -1;
    }

    @Override
    public int getSize() {
        return this._array.length;
    }

    @Override
    public E getElementAt(int j) {
        return (E)this._array[j];
    }

    @Override
    public void sort(Comparator<E> cmpr, boolean ascending) {
        Arrays.sort(this._array, cmpr);
        this.fireEvent(3, -1, -1);
    }

    public boolean equals(Object o) {
        return this._array.equals(o instanceof ListModelArray ? ((ListModelArray)o)._array : o);
    }

    public int hashCode() {
        return this._array.hashCode();
    }

    public String toString() {
        return Objects.toString((Object)this._array);
    }
}

