/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.zkoss.lang.Objects;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ext.Sortable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListModelMap<K, V>
extends AbstractListModel<Map.Entry<K, V>>
implements Sortable<Map.Entry<K, V>>,
Map<K, V>,
Serializable {
    protected Map<K, V> _map;

    public ListModelMap(Map<K, V> map, boolean live) {
        this._map = live ? map : new LinkedHashMap(map);
    }

    public ListModelMap() {
        this._map = new LinkedHashMap();
    }

    public ListModelMap(Map<? extends K, ? extends V> map) {
        this._map = new LinkedHashMap<K, V>(map);
    }

    public ListModelMap(int initialCapacity) {
        this._map = new LinkedHashMap(initialCapacity);
    }

    public ListModelMap(int initialCapacity, float loadFactor) {
        this._map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    public Map<K, V> getInnerMap() {
        return this._map;
    }

    @Override
    public int getSize() {
        return this._map.size();
    }

    @Override
    public Map.Entry<K, V> getElementAt(int j) {
        Map.Entry<K, V> o;
        if (j < 0 || j >= this._map.size()) {
            throw new IndexOutOfBoundsException("" + j);
        }
        Iterator<Map.Entry<K, V>> it = this._map.entrySet().iterator();
        do {
            o = it.next();
        } while (--j >= 0);
        return o;
    }

    @Override
    public void clear() {
        int i2 = this._map.size() - 1;
        if (i2 < 0) {
            return;
        }
        this.clearSelection();
        this._map.clear();
        this.fireEvent(2, 0, i2);
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Entries(this._map.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this._map).equals(o instanceof ListModelMap ? ((ListModelMap)o)._map : o);
    }

    public String toString() {
        return this._map.toString();
    }

    @Override
    public V get(Object key) {
        return this._map.get(key);
    }

    @Override
    public int hashCode() {
        return ((Object)this._map).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new Keys(this._map.keySet());
    }

    @Override
    public V put(K key, V o) {
        V ret;
        if (this._map.containsKey(key)) {
            if (Objects.equals(o, this._map.get(key))) {
                return o;
            }
            int index = this.indexOfKey(key);
            ret = this._map.put(key, o);
            this.fireEvent(0, index, index);
        } else {
            ret = this._map.put(key, o);
            if (this._map instanceof LinkedHashMap) {
                int i1 = this._map.size() - 1;
                this.fireEvent(1, i1, i1);
            } else if (this._map instanceof SortedMap) {
                int i1 = this.indexOfKey(key);
                this.fireEvent(1, i1, i1);
            } else {
                this.fireEvent(0, -1, -1);
            }
        }
        return ret;
    }

    public int indexOfKey(Object o) {
        int j = 0;
        Iterator<K> it = this._map.keySet().iterator();
        while (it.hasNext()) {
            if (Objects.equals((Object)o, it.next())) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public int indexOf(Object o) {
        int j = 0;
        Iterator<Map.Entry<K, V>> it = this._map.entrySet().iterator();
        while (it.hasNext()) {
            if (Objects.equals((Object)o, it.next())) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> c) {
        if (c == this._map) {
            return;
        }
        if (this._map instanceof LinkedHashMap) {
            int sz = c.size();
            if (sz <= 0) {
                return;
            }
            ArrayList<Map.Entry<K, V>> added = new ArrayList<Map.Entry<K, V>>(c.size());
            for (Map.Entry<K, V> entry : c.entrySet()) {
                K key = entry.getKey();
                if (this._map.containsKey(key)) {
                    this.put(key, entry.getValue());
                    continue;
                }
                added.add(entry);
            }
            for (Map.Entry<K, V> entry : added) {
                this._map.put(entry.getKey(), entry.getValue());
            }
            int len = added.size();
            if (len > 0) {
                this.fireEvent(1, sz, sz + len - 1);
            }
        } else {
            this._map.putAll(c);
            this.fireEvent(0, -1, -1);
        }
    }

    @Override
    public V remove(Object key) {
        if (this._map.containsKey(key)) {
            V ret = null;
            this.removeSelectionByKey(key);
            if (this._map instanceof LinkedHashMap || this._map instanceof SortedMap) {
                int index = this.indexOfKey(key);
                ret = this._map.remove(key);
                this.fireEvent(2, index, index);
            } else {
                ret = this._map.remove(key);
                this.fireEvent(0, -1, -1);
            }
            return ret;
        }
        return null;
    }

    private void removeSelectionByKey(Object key) {
        for (Map.Entry entry : this.getSelection()) {
            if (!Objects.equals((Object)key, entry.getKey())) continue;
            this.removeSelection(entry);
            return;
        }
    }

    private void removeSelectionByValue(Object value) {
        for (Map.Entry entry : this.getSelection()) {
            if (!Objects.equals((Object)value, entry.getValue())) continue;
            this.removeSelection(entry);
            return;
        }
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<V> values() {
        return new Values(this._map.values());
    }

    @Override
    public void sort(Comparator<Map.Entry<K, V>> cmpr, boolean ascending) {
        ArrayList<Map.Entry<K, V>> copy = new ArrayList<Map.Entry<K, V>>(this._map.entrySet());
        Collections.sort(copy, cmpr);
        this._map.clear();
        for (Map.Entry entry : copy) {
            this._map.put(entry.getKey(), entry.getValue());
        }
        this.fireEvent(3, -1, -1);
    }

    private boolean removePartial(Collection<?> master, Collection<?> c, boolean isRemove, boolean byKey, boolean byValue) {
        int sz = c.size();
        int removed = 0;
        int retained = 0;
        int index = 0;
        int begin = -1;
        Iterator<?> it = master.iterator();
        while (!(!it.hasNext() || isRemove && removed >= sz || !isRemove && retained >= sz)) {
            Object item = it.next();
            if (c.contains(item) == isRemove) {
                if (begin < 0) {
                    begin = index;
                }
                ++removed;
                if (byKey) {
                    this.removeSelectionByKey(item);
                } else if (byValue) {
                    this.removeSelectionByValue(item);
                } else {
                    this.removeSelection(item);
                }
                it.remove();
            } else {
                ++retained;
                if (begin >= 0) {
                    this.fireEvent(2, begin, index - 1);
                    index = begin;
                    begin = -1;
                }
            }
            ++index;
        }
        if (begin >= 0) {
            this.fireEvent(2, begin, index - 1);
        }
        return removed > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends MyCol<V> {
        private Collection<V> _col;

        public Values(Collection<V> col) {
            super(col);
        }

        @Override
        public void clear() {
            int i2 = this._col.size() - 1;
            if (i2 < 0) {
                return;
            }
            ListModelMap.this.clearSelection();
            this._col.clear();
            ListModelMap.this.fireEvent(2, 0, i2);
        }

        private int indexOfAndRemove(Object o) {
            int j = 0;
            Iterator it = this._col.iterator();
            while (it.hasNext()) {
                Object val = it.next();
                if (Objects.equals(val, (Object)o)) {
                    ListModelMap.this.removeSelection(o);
                    it.remove();
                    return j;
                }
                ++j;
            }
            return -1;
        }

        @Override
        public boolean remove(Object o) {
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                int index = this.indexOfAndRemove(o);
                if (index < 0) {
                    return false;
                }
                ListModelMap.this.fireEvent(2, index, index);
                return true;
            }
            ListModelMap.this.removeSelection(o);
            boolean ret = this._col.remove(o);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this._col == c || this == c) {
                ListModelMap.this.clearSelection();
                this.clear();
                return true;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._col, c, true, false, true);
            }
            ListModelMap.this.removeAllSelection(c);
            boolean ret = this._col.removeAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this._col == c || this == c) {
                return false;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._col, c, false, false, true);
            }
            ListModelMap.this.retainAllSelection(c);
            boolean ret = this._col.retainAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MyCol<E>
    implements Collection<E> {
        protected Collection<E> _col;

        public MyCol(Collection<E> col) {
            this._col = col;
        }

        @Override
        public Iterator<E> iterator() {
            return new MyIterator<E>(this._col.iterator());
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException("add()");
        }

        @Override
        public boolean addAll(Collection<? extends E> col) {
            throw new UnsupportedOperationException("addAll()");
        }

        @Override
        public boolean contains(Object o) {
            return this._col == null ? false : this._col.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this._col == null ? false : this._col.containsAll(c);
        }

        @Override
        public int hashCode() {
            return this._col == null ? 0 : ((Object)this._col).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MyCol) {
                return Objects.equals(((MyCol)o)._col, this._col);
            }
            return Objects.equals(this._col, (Object)o);
        }

        @Override
        public boolean isEmpty() {
            return this._col == null ? true : this._col.isEmpty();
        }

        @Override
        public int size() {
            return this._col == null ? 0 : this._col.size();
        }

        @Override
        public Object[] toArray() {
            return this._col == null ? new Object[]{} : this._col.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this._col == null ? a : this._col.toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entries
    extends MySet<Map.Entry<K, V>> {
        private Entries(Set<Map.Entry<K, V>> inner) {
            super(inner, false);
        }

        @Override
        protected int indexOf(Object o) {
            return ListModelMap.this.indexOf(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Keys
    extends MySet<K> {
        public Keys(Set<K> inner) {
            super(inner, true);
        }

        @Override
        protected int indexOf(Object o) {
            return ListModelMap.this.indexOfKey(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MySet<E>
    implements Set<E> {
        private final Set<E> _set;
        private final boolean _keyset;

        public MySet(Set<E> inner, boolean keyset) {
            this._set = inner;
            this._keyset = keyset;
        }

        @Override
        public void clear() {
            int i2 = this._set.size() - 1;
            if (i2 < 0) {
                return;
            }
            ListModelMap.this.clearSelection();
            this._set.clear();
            ListModelMap.this.fireEvent(2, 0, i2);
        }

        @Override
        public boolean remove(Object o) {
            boolean ret = false;
            if (this._set.contains(o)) {
                ListModelMap.this.removeSelection(o);
                if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                    int index = this.indexOf(o);
                    ret = this._set.remove(o);
                    ListModelMap.this.fireEvent(2, index, index);
                } else {
                    ret = this._set.remove(o);
                    ListModelMap.this.fireEvent(0, -1, -1);
                }
            }
            return ret;
        }

        protected abstract int indexOf(Object var1);

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this._set == c || this == c) {
                this.clear();
                return true;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._set, c, true, this._keyset, false);
            }
            ListModelMap.this.removeAllSelection(c);
            boolean ret = this._set.removeAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this._set == c || this == c) {
                return false;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._set, c, false, this._keyset, false);
            }
            ListModelMap.this.retainAllSelection(c);
            boolean ret = this._set.retainAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        @Override
        public Iterator<E> iterator() {
            return new MyIterator<E>(this._set.iterator());
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException("add()");
        }

        @Override
        public boolean addAll(Collection<? extends E> col) {
            throw new UnsupportedOperationException("addAll()");
        }

        @Override
        public boolean contains(Object o) {
            return this._set == null ? false : this._set.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this._set == null ? false : this._set.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MySet) {
                return Objects.equals(((MySet)o)._set, this._set);
            }
            return Objects.equals(this._set, (Object)o);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this._set);
        }

        @Override
        public boolean isEmpty() {
            return this._set == null || this._set.isEmpty();
        }

        @Override
        public int size() {
            return this._set == null ? 0 : this._set.size();
        }

        @Override
        public Object[] toArray() {
            return this._set == null ? new Object[]{} : this._set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this._set == null ? a : this._set.toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyIterator<E>
    implements Iterator<E> {
        private Iterator<E> _it;
        private E _current;
        private int _index = -1;

        public MyIterator(Iterator<E> inner) {
            this._it = inner;
            this._index = -1;
        }

        @Override
        public boolean hasNext() {
            return this._it.hasNext();
        }

        @Override
        public E next() {
            ++this._index;
            this._current = this._it.next();
            return this._current;
        }

        @Override
        public void remove() {
            if (this._index >= 0) {
                ListModelMap.this.removeSelection(this._current);
                this._it.remove();
                if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                    ListModelMap.this.fireEvent(2, this._index, this._index);
                } else {
                    ListModelMap.this.fireEvent(0, -1, -1);
                }
            }
        }
    }
}

