/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Menubar;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.impl.LabelImageElement;

public class Menu
extends LabelImageElement {
    private Menupopup _popup;
    private String _content = "";

    public Menu() {
    }

    public Menu(String label) {
        super(label);
    }

    public Menu(String label, String src) {
        super(label, src);
    }

    public boolean isTopmost() {
        return !(this.getParent() instanceof Menupopup);
    }

    public Menupopup getMenupopup() {
        return this._popup;
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content == null) {
            content = "";
        }
        if (!Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this.smartUpdate("content", content);
        }
    }

    public void open() {
        if (this.getParent() instanceof Menubar) {
            this.response("menu", (AuResponse)new AuInvoke((Component)this, "open", null));
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-menu" : this._zclass;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "content", this._content);
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Menubar) && !(parent instanceof Menupopup)) {
            throw new UiException("Unsupported parent for menu: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (child instanceof Menupopup) {
            if (this._popup != null && this._popup != child) {
                throw new UiException("Only one menupopup is allowed: " + (Object)((Object)this));
            }
        } else {
            throw new UiException("Unsupported child for menu: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public void onChildRemoved(Component child) {
        this._popup = null;
        super.onChildRemoved(child);
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof Menupopup) {
            if (super.insertBefore(child, refChild)) {
                this._popup = (Menupopup)child;
                return true;
            }
        } else {
            return super.insertBefore(child, refChild);
        }
        return false;
    }

    public Object clone() {
        Menu clone = (Menu)((Object)super.clone());
        if (clone._popup != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        this._popup = (Menupopup)this.getFirstChild();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (!this.getChildren().isEmpty()) {
            this.afterUnmarshal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onClick")) {
            Events.postEvent((Event)MouseEvent.getMouseEvent((AuRequest)request));
        } else if (cmd.equals("onChange")) {
            Map data = request.getData();
            if (this.getContent().indexOf("#color") == 0) {
                this.disableClientUpdate(true);
                try {
                    this.setContent("#color=" + (String)data.get("color"));
                }
                finally {
                    this.disableClientUpdate(false);
                }
                Events.postEvent((Event)InputEvent.getInputEvent((AuRequest)request, (Object)this._content));
            }
        } else {
            super.service(request, everError);
        }
    }

    static {
        Menu.addClientEvent(Menu.class, (String)"onClick", (int)8193);
        Menu.addClientEvent(Menu.class, (String)"onChange", (int)8193);
    }
}

