/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.zul.AbstractChartModel;
import org.zkoss.zul.XYModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXYModel
extends AbstractChartModel
implements XYModel {
    private static final long serialVersionUID = 20091008182904L;
    protected Map<Comparable<?>, List<XYPair>> _seriesMap = new HashMap(8);
    protected List<Comparable<?>> _seriesList = new ArrayList();
    private boolean _autoSort = true;

    @Override
    public Comparable<?> getSeries(int index) {
        return this._seriesList.get(index);
    }

    @Override
    public Collection<Comparable<?>> getSeries() {
        return this._seriesList;
    }

    @Override
    public int getDataCount(Comparable<?> series) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        return xyPairs != null ? xyPairs.size() : 0;
    }

    @Override
    public Number getX(Comparable<?> series, int index) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        if (xyPairs != null) {
            return xyPairs.get(index).getX();
        }
        return null;
    }

    @Override
    public Number getY(Comparable<?> series, int index) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        if (xyPairs != null) {
            return xyPairs.get(index).getY();
        }
        return null;
    }

    @Override
    public void setValue(Comparable<?> series, Number x, Number y, int index) {
        this.removeValue0(series, index);
        this.addValue0(series, x, y, index);
        this.fireEvent(0, series, null);
    }

    @Override
    public void addValue(Comparable<?> series, Number x, Number y) {
        this.addValue(series, x, y, -1);
    }

    @Override
    public void addValue(Comparable<?> series, Number x, Number y, int index) {
        this.addValue0(series, x, y, index);
        this.fireEvent(0, series, null);
    }

    private void addValue0(Comparable<?> series, Number x, Number y, int index) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        if (xyPairs == null) {
            xyPairs = new ArrayList<XYPair>(15);
            this._seriesMap.put(series, xyPairs);
            this._seriesList.add(series);
        }
        if (index >= 0) {
            xyPairs.add(index, new XYPair(x, y));
        } else {
            xyPairs.add(new XYPair(x, y));
        }
    }

    @Override
    public void setAutoSort(boolean auto) {
        this._autoSort = auto;
    }

    @Override
    public boolean isAutoSort() {
        return this._autoSort;
    }

    @Override
    public void removeSeries(Comparable<?> series) {
        this._seriesMap.remove(series);
        this._seriesList.remove(series);
        this.fireEvent(2, series, null);
    }

    @Override
    public void removeValue(Comparable<?> series, int index) {
        this.removeValue0(series, index);
        this.fireEvent(2, series, null);
    }

    private void removeValue0(Comparable<?> series, int index) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        if (xyPairs == null) {
            return;
        }
        xyPairs.remove(index);
    }

    @Override
    public void clear() {
        this._seriesMap.clear();
        this._seriesList.clear();
        this.fireEvent(2, null, null);
    }

    protected static class XYPair
    implements Serializable {
        private static final long serialVersionUID = 20091008182941L;
        private Number _x;
        private Number _y;

        protected XYPair(Number x, Number y) {
            this._x = x;
            this._y = y;
        }

        public Number getX() {
            return this._x;
        }

        public Number getY() {
            return this._y;
        }
    }
}

